<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\InboxController;
use App\Http\Controllers\AuthController;
use Illuminate\Support\Facades\Route;

// Landing Page
Route::get('/', [HomeController::class, 'index'])->name('home');

// Search & Browse Rides
Route::get('/search', [HomeController::class, 'searchRides'])->name('rides.search');
Route::get('/rides', [HomeController::class, 'searchRides'])->name('rides.index');

// Ride Management (Offer a Ride)
Route::get('/rides/create', [HomeController::class, 'createRide'])->name('rides.create');
Route::post('/rides', [HomeController::class, 'storeRide'])->name('rides.store');

// Dashboard
Route::get('/dashboard', [HomeController::class, 'dashboard'])->name('dashboard');
Route::get('/driver/dashboard', [HomeController::class, 'driverDashboard'])->name('driver.dashboard');

// Inbox Routes
Route::get('/inbox', [InboxController::class, 'index'])->name('inbox');
Route::get('/inbox/demo', [InboxController::class, 'createDemo'])->name('inbox.demo');
Route::get('/inbox/{id}', [InboxController::class, 'show'])->name('inbox.show');
Route::post('/inbox/{id}/send', [InboxController::class, 'sendMessage'])->name('inbox.send');
Route::post('/inbox/start', [InboxController::class, 'startConversation'])->name('inbox.start');

// Profile Routes
Route::get('/profile', [ProfileController::class, 'index'])->name('profile');
Route::post('/profile/update', [ProfileController::class, 'update'])->name('profile.update');
Route::post('/profile/avatar', [ProfileController::class, 'uploadAvatar'])->name('profile.avatar');
Route::post('/profile/kyc', [ProfileController::class, 'submitKyc'])->name('profile.kyc');
Route::post('/profile/vehicle', [ProfileController::class, 'addVehicle'])->name('profile.vehicle.add');
Route::delete('/profile/vehicle/{id}', [ProfileController::class, 'deleteVehicle'])->name('profile.vehicle.delete');

// Booking Flow
Route::get('/bookings/create', [HomeController::class, 'createBooking'])->name('bookings.create');
Route::post('/bookings', [HomeController::class, 'storeBooking'])->name('bookings.store');

// Auth Routes
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.post');
Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register'])->name('register.post');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Admin Routes
use App\Http\Controllers\AdminController;

Route::prefix('admin')->group(function () {
    Route::get('/login', [AdminController::class, 'showLogin'])->name('admin.login');
    Route::post('/login', [AdminController::class, 'login'])->name('admin.login.post');
    Route::post('/logout', [AdminController::class, 'logout'])->name('admin.logout');
    
    Route::get('/', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard.alt');
    
    // Users CRUD
    Route::get('/users', [AdminController::class, 'users'])->name('admin.users');
    Route::get('/users/create', [AdminController::class, 'createUser'])->name('admin.users.create');
    Route::post('/users', [AdminController::class, 'storeUser'])->name('admin.users.store');
    Route::get('/users/{id}/edit', [AdminController::class, 'editUser'])->name('admin.users.edit');
    Route::put('/users/{id}', [AdminController::class, 'updateUser'])->name('admin.users.update');
    Route::post('/users/{id}/verify', [AdminController::class, 'verifyUser'])->name('admin.users.verify');
    Route::post('/users/{id}/toggle-admin', [AdminController::class, 'toggleAdmin'])->name('admin.users.toggle-admin');
    Route::delete('/users/{id}', [AdminController::class, 'deleteUser'])->name('admin.users.delete');
    
    Route::get('/rides', [AdminController::class, 'rides'])->name('admin.rides');
    Route::get('/bookings', [AdminController::class, 'bookings'])->name('admin.bookings');
    
    Route::get('/vehicles', [AdminController::class, 'vehicles'])->name('admin.vehicles');
    Route::post('/vehicles/{id}/verify', [AdminController::class, 'verifyVehicle'])->name('admin.vehicles.verify');
    
    // Payments
    Route::get('/payments', [AdminController::class, 'payments'])->name('admin.payments');
    Route::post('/payments/settings', [AdminController::class, 'updatePaymentSettings'])->name('admin.payments.update-settings');
    Route::post('/payments/pricing', [AdminController::class, 'updatePricing'])->name('admin.payments.update-pricing');
    Route::post('/payments/{id}/verify', [AdminController::class, 'verifyPayment'])->name('admin.payments.verify');
    
    // KYC Verification
    Route::get('/kyc', [AdminController::class, 'kyc'])->name('admin.kyc');
    Route::post('/kyc/{id}/approve', [AdminController::class, 'approveKyc'])->name('admin.kyc.approve');
    Route::post('/kyc/{id}/reject', [AdminController::class, 'rejectKyc'])->name('admin.kyc.reject');
    Route::post('/kyc/{id}/revoke', [AdminController::class, 'revokeKyc'])->name('admin.kyc.revoke');
    
    Route::get('/settings', [AdminController::class, 'settings'])->name('admin.settings');
});
