

<?php $__env->startSection('title', 'Edit User'); ?>
<?php $__env->startSection('page-title', $user->id ? 'Edit User' : 'Add New User'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card" style="max-width: 700px;">
        <div class="card-header">
            <h3 class="card-title"><?php echo e($user->id ? '✏️ Edit User Details' : '➕ Create New User'); ?></h3>
        </div>
        <div style="padding: 24px;">
            <form action="<?php echo e($user->id ? route('admin.users.update', $user->id) : route('admin.users.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php if($user->id): ?>
                    <?php echo method_field('PUT'); ?>
                <?php endif; ?>

                <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 16px; margin-bottom: 20px;">
                    <div>
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Full Name *</label>
                        <input type="text" name="name" value="<?php echo e(old('name', $user->name)); ?>" required style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                    </div>
                    <div>
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Email *</label>
                        <input type="email" name="email" value="<?php echo e(old('email', $user->email)); ?>" required style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                    </div>
                </div>

                <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 16px; margin-bottom: 20px;">
                    <div>
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Phone</label>
                        <input type="text" name="phone" value="<?php echo e(old('phone', $user->phone)); ?>" placeholder="+92 300 1234567" style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                    </div>
                    <div>
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">User Type *</label>
                        <select name="user_type" required style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px; background: white;">
                            <option value="passenger" <?php echo e(old('user_type', $user->user_type) == 'passenger' ? 'selected' : ''); ?>>Passenger</option>
                            <option value="driver" <?php echo e(old('user_type', $user->user_type) == 'driver' ? 'selected' : ''); ?>>Driver</option>
                            <option value="both" <?php echo e(old('user_type', $user->user_type) == 'both' ? 'selected' : ''); ?>>Both</option>
                        </select>
                    </div>
                </div>

                <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 16px; margin-bottom: 20px;">
                    <div>
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;"><?php echo e($user->id ? 'New Password (leave blank to keep)' : 'Password *'); ?></label>
                        <input type="password" name="password" <?php echo e($user->id ? '' : 'required'); ?> placeholder="••••••••" style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                    </div>
                    <div>
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Confirm Password</label>
                        <input type="password" name="password_confirmation" placeholder="••••••••" style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                    </div>
                </div>

                <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 16px; margin-bottom: 20px;">
                    <div>
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">CNIC Number</label>
                        <input type="text" name="cnic" value="<?php echo e(old('cnic', $user->cnic)); ?>" placeholder="12345-1234567-1" style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                    </div>
                    <div>
                        <label style="display: block; font-size: 12px; font-weight: 700; color: #64748b; margin-bottom: 8px;">Address</label>
                        <input type="text" name="address" value="<?php echo e(old('address', $user->address)); ?>" placeholder="City, Pakistan" style="width: 100%; padding: 12px 16px; border: 2px solid #e2e8f0; border-radius: 10px; font-size: 14px;">
                    </div>
                </div>

                <!-- Status Toggles -->
                <div style="background: #f8fafc; border-radius: 12px; padding: 20px; margin-bottom: 20px;">
                    <div style="font-weight: 700; color: #334155; margin-bottom: 16px;">Account Status</div>
                    <div style="display: flex; flex-wrap: wrap; gap: 24px;">
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input type="checkbox" name="is_verified" value="1" <?php echo e(old('is_verified', $user->is_verified) ? 'checked' : ''); ?> style="width: 20px; height: 20px; accent-color: #10b981;">
                            <span style="font-size: 14px; font-weight: 600;">✅ Verified User</span>
                        </label>
                        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                            <input type="checkbox" name="is_admin" value="1" <?php echo e(old('is_admin', $user->is_admin) ? 'checked' : ''); ?> style="width: 20px; height: 20px; accent-color: #00aff5;">
                            <span style="font-size: 14px; font-weight: 600;">👑 Admin Access</span>
                        </label>
                    </div>
                </div>

                <div style="display: flex; gap: 12px;">
                    <button type="submit" class="btn btn-primary" style="flex: 1;">
                        <?php echo e($user->id ? '💾 Update User' : '➕ Create User'); ?>

                    </button>
                    <a href="<?php echo e(route('admin.users')); ?>" class="btn" style="background: #e2e8f0; color: #334155;">Cancel</a>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/admin/user-edit.blade.php ENDPATH**/ ?>